% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi.ce.R
\name{multi.ce}
\alias{multi.ce}
\alias{multi.ce.bcea}
\title{Cost-effectiveness Analysis With Multiple Comparison}
\usage{
\method{multi.ce}{bcea}(he)
}
\arguments{
\item{he}{A \code{bcea} object containing the results of the Bayesian
modelling and the economic evaluation.}
}
\value{
Original \code{bcea} object (list) of class "pairwise" with additional:
   \item{p_best_interv}{A matrix including the probability that each
   intervention is the most cost-effective for all values of the willingness to
   pay parameter}
   \item{ceaf}{A vector containing the cost-effectiveness acceptability frontier}
}
\description{
Computes and plots the probability that each of the \code{n_int} interventions
being analysed is the most cost-effective and the cost-effectiveness
acceptability frontier.
}
\examples{
# See Baio G., Dawid A.P. (2011) for a detailed description of the 
# Bayesian model and economic problem

# Load the processed results of the MCMC simulation model
data(Vaccine)
 
# Runs the health economic evaluation using BCEA

m <- bcea(e=eff, c=cost,    # defines the variables of 
                            #  effectiveness and cost
      ref=2,                # selects the 2nd row of (e,c) 
                            #  as containing the reference intervention
      interventions=treats, # defines the labels to be associated 
                            #  with each intervention
      Kmax=50000,           # maximum value possible for the willingness 
                            #  to pay threshold; implies that k is chosen 
                            #  in a grid from the interval (0,Kmax)
      plot=FALSE            # inhibits graphical output
)

mce <- multi.ce(m)          # uses the results of the economic analysis

ceac.plot(mce)
ceaf.plot(mce)

}
\seealso{
\code{\link{bcea}},
         \code{\link{ceaf.plot}}
}
\author{
Gianluca Baio
}
\keyword{dplot}
\keyword{hplot}
