% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraping_games_acb.R
\name{scraping_games_acb}
\alias{scraping_games_acb}
\title{ACB player game finder data}
\usage{
scraping_games_acb(type_league, nums, year, verbose = TRUE, 
                   accents = FALSE, r_user = "guillermo.vinue@uv.es")
}
\arguments{
\item{type_league}{String. If \code{competition} is ACB, to scrape 
ACB league games ("ACB"), Copa del Rey games ("CREY") or Supercopa games ("SCOPA").}

\item{nums}{Numbers corresponding to the website to scrape.}

\item{year}{Season, e.g. 2017-2018.}

\item{verbose}{Should R report information on progress? Default TRUE.}

\item{accents}{Should we keep the Spanish accents? The recommended 
option is to remove them, so default FALSE.}

\item{r_user}{Email to identify the user when doing web scraping. 
This is a polite way to do web scraping and to certify that the user 
is working as transparently as possible with a research purpose.}
}
\value{
A data frame with the player game finder data.
}
\description{
This function allows us to get all the player game finder data for 
all the desired ACB seasons available from: 
\url{http://www.acb.com}.
}
\details{
The official website of the Spanish basketball league ACB presents the
statistics of each game in a php website, such as:
http://www.acb.com/fichas/LACB62090.php.

Note that for example http://www.acb.com/fichas/LACB60315.php
doesn't exist, so for these cases is where we can use the 
 \code{httr} package.

In \url{https://www.uv.es/vivigui/docs/acb_scraping.pdf} a document 
is available with the exact numbers xxxxx related to
http://www.acb.com/fichas/LACBxxxxx.php for some seasons.
}
\note{
In addition to use the email address to stay identifiable, the function also 
contains two headers regarding the R platform and version used.

Furthermore, even though in the robots.txt file at 
\url{http://www.acb.com/robots.txt}, there is no information about scraping
limitations and all robots are allowed to have complete access,
the function also includes the command \code{Sys.sleep(2)}
to pause between requests for 2 seconds. In this way, we don't bother the server 
with multiple requests and we do carry out a friendly scraping.
}
\examples{
\dontrun{
# Not needed to scrape every time the package is checked, built and installed.
df1 <- scraping_games_acb(type_league = "ACB", nums = 62001:62002, year = "2017-2018",
                          verbose = TRUE, accents = FALSE, 
                          r_user = "guillermo.vinue@uv.es")
}                           

}
\seealso{
\code{\link{do_scraping_games}}
}
\author{
Guillermo Vinue
}
