% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypergeometric1F1.R
\name{hypergeometric1F1}
\alias{hypergeometric1F1}
\title{Confluent hypergeometric1F1 function}
\usage{
hypergeometric1F1(a, b, c, laplace = FALSE, log = TRUE)
}
\arguments{
\item{a}{arbitrary}

\item{b}{Must be greater 0}

\item{c}{arbitrary}

\item{laplace}{The default is to use the Cephes library; for large a or s
this may return an NA, Inf or negative values,, in which case you should use
the Laplace approximation.}

\item{log}{if TRUE, return log(1F1)}
}
\description{
Compute the Confluent Hypergeometric function: 1F1(a,b,c,t) =
Gamma(b)/(Gamma(b-a)Gamma(a)) Int_0^1 t^(a-1) (1 - t)^(b-a-1) exp(c t) dt
}
\examples{
hypergeometric1F1(11.14756, 0.5, 0.00175097)


}
\references{
Cephes library hyp1f1.c
}
\seealso{
Other special functions: 
\code{\link{hypergeometric2F1}()},
\code{\link{phi1}()},
\code{\link{trCCH}()}
}
\author{
Merlise Clyde (\email{clyde@stat.duke.edu})
}
\concept{special functions}
\keyword{math}
