% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_model_select.R
\name{fit_stepwise_univariate}
\alias{fit_stepwise_univariate}
\title{Component size selection via stepwise incremented univariate mixture models}
\usage{
fit_stepwise_univariate(data, model, fn = mean,  start_ncomp = 1,
                        max_ncomp = 10, crit = "WAIC", form = 1,
                        prev.par = FALSE, burnin = 1/3, thin = 1, ...)
}
\arguments{
\item{data}{vector of observations. If outside, the values are transformed into the scale \eqn{[0, 2\pi)}.}

\item{model}{univariate angular mixture model to be fitted.  Must be one of \code{"vm"} or \code{"wnorm"}.}

\item{fn}{function to evaluate on MCMC samples to estimate parameters.
Defaults to \code{mean}, which computes the estimated posterior means. Ignored if \code{prev.par} is \code{FALSE}.}

\item{start_ncomp}{starting component size. A single component model is fitted if \code{start_ncomp} is equal to one.}

\item{max_ncomp}{maximum number of components allowed in the mixture model.}

\item{crit}{criteria for model comparison, one of \code{"AIC", "BIC", "DIC"} or \code{"WAIC"}. Default is
\code{"WAIC"}.}

\item{form}{form of crit to be used. Available choices are 1 and 2. Used only if crit is \code{"WAIC"} or
\code{"DIC"} and ignored otherwise.}

\item{prev.par}{logical. Should the final parameters from the model with \code{ncomp = K} be used in the model
with \code{ncomp = K+1} as the starting parameters?}

\item{burnin}{initial fraction of the MCMC samples to be discarded as burn-in. Must be a value in [0, 1).}

\item{thin}{positive integer. If \code{thin =} \eqn{n}, only every \eqn{n}-th realizations of the Markov chain is kept.}

\item{...}{additional arguments passed to \link{fit_vmmix} or \link{fit_wnormmix}, depending on \code{model}.}
}
\value{
Returns a named list with the following seven elements:

\code{fit.all} - a list all angmcmc objects created at each component size;

\code{fit.best} - angmcmc object corresponding to the optimum component size;

\code{ncomp.best} - optimum component size (integer);

\code{crit} - which model comparison criterion used (one of \code{"AIC", "BIC", "DIC"} or \code{"WAIC"});

\code{crit.all} - all \code{crit} values calculated (for all component sizes);

\code{crit.best} - \code{crit} value for the optimum component size; and

\code{check_min} - logical; is the optimum component size less than \code{max_ncomp}?
}
\description{
Component size selection via stepwise incremented univariate mixture models
}
\details{
The default \code{method} is \code{"hmc"}. Each fit uses the number of MCMC iterations specified by
the argument \code{n.iter} (passed to \link{fit_vmmix} or \link{fit_wnormmix}, as specified
through the argument \code{model}).
}
\examples{
# illustration only - more iterations needed for convergence
fit.vm.step.15 <- fit_stepwise_univariate(wind, "vm", start_ncomp = 1,
                                          max_ncomp = 3, n.iter = 15,
                                          ncores = 1)
(fit.vm.best.15 <- bestmodel(fit.vm.step.15))
densityplot1d(fit.vm.best.15)

}
