% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_dunnett.R
\name{summarise_dunnett}
\alias{summarise_dunnett}
\title{Utils: Dunnett's Test Summary}
\usage{
summarise_dunnett(variable, colnames = NA, info = "sig")
}
\arguments{
\item{variable}{List object Dunnett test}

\item{colnames}{Names of column}

\item{info}{Information of table}
}
\value{
A summary table from Dunnett's test is returned
}
\description{
Performs a summary in table form from a list of Dunnett's test outputs
}
\examples{
library(AgroR)
data("pomegranate")
a=with(pomegranate,dunnett(trat=trat,resp=WL,control="T1"))
b=with(pomegranate,dunnett(trat=trat,resp=SS,control="T1"))
c=with(pomegranate,dunnett(trat=trat,resp=AT,control="T1"))
d=with(pomegranate,dunnett(trat=trat,resp=ratio,control="T1"))
summarise_dunnett(list(a,b,c,d))
}
