% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bargraph_onefactor.R
\name{bargraph_onefactor}
\alias{bargraph_onefactor}
\title{Graph: Group DIC, DBC and DQL functions column charts}
\usage{
bargraph_onefactor(
  analysis,
  labels = NULL,
  ocult.facet = FALSE,
  ocult.box = FALSE,
  facet.size = 14,
  ylab = NULL,
  width.bar = 0.3,
  width.col = 0.9,
  sup = NULL
)
}
\arguments{
\item{analysis}{List with DIC, DBC or DQL object}

\item{labels}{Vector with the name of the facets}

\item{ocult.facet}{Hide facets}

\item{ocult.box}{Hide box}

\item{facet.size}{Font size facets}

\item{ylab}{Y-axis name}

\item{width.bar}{Width error bar}

\item{width.col}{Width Column}

\item{sup}{Number of units above the standard deviation or average bar on the graph}
}
\value{
Returns a column chart grouped by facets
}
\description{
Groups two or more column charts exported from DIC, DBC or DQL function
}
\examples{
library(AgroR)
data("laranja")
a=with(laranja, DBC(trat, bloco, resp, ylab = "Number of fruits/plants"))
b=with(laranja, DBC(trat, bloco, resp,  ylab = "Number of fruits/plants"))
c=with(laranja, DBC(trat, bloco, resp, ylab = "Number of fruits/plants"))
bargraph_onefactor(analysis = list(a,b,c), labels = c("One","Two","Three"),ocult.box = TRUE)
}
