% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_trend.R
\name{plot_trend}
\alias{plot_trend}
\title{Calculating and Plotting Trends of Pollen Data.}
\usage{
plot_trend(
  data,
  base_dir = getwd(),
  table_dir = file.path(base_dir, "table_AeRobiology"),
  interpolation = TRUE,
  int.method = "lineal",
  export.plot = TRUE,
  export.format = "pdf",
  export.result = TRUE,
  method = "percentage",
  ...
)
}
\arguments{
\item{data}{A \code{data.frame} object. This \code{data.frame} should include a first column in format \code{Date} and the rest of columns in format \code{numeric} belonging to each pollen type by column.}

\item{base_dir}{Character. Base directory where output tables are stored.}

\item{table_dir}{Character. Directory where tables are exported.}

\item{interpolation}{A \code{logical} value specifying if the visualization shows the gaps in the inputs data (\code{interpolation = FALSE}) or if an interpolation method is used for filling the gaps (\code{interpolation = TRUE}). By default, \code{interpolation = TRUE}.}

\item{int.method}{A \code{character} string with the name of the interpolation method to be used. The implemented methods that may be used are: \code{"lineal"}, \code{"movingmean"}, \code{"tseries"} or \code{"spline"}. By default, \code{int.method = "lineal"}.}

\item{export.plot}{A \code{logical} value specifying if a plot will be exported or not. If \code{FALSE} graphical results will only be displayed in the active graphics window. If \code{TRUE} graphical results will be displayed in the active graphics window and also one pdf/png file will be saved within the \emph{plot_AeRobiology} directory automatically created in the working directory. By default, \code{export.plot = TRUE}.}

\item{export.format}{A \code{character} string specifying the format selected to save the plot. The implemented formats that may be used are: \code{"pdf"} or \code{"png"}. By default, \code{export.format = "pdf"}.}

\item{export.result}{A \code{logical} value. If \code{export.result = TRUE}, a table is exported with the extension \emph{.xlsx}, in the directory \emph{table_AeRobiology}. This table has the information about the \code{slope} \emph{"beta coefficient of a lineal model using as predictor the year and as dependent variable one of the main pollen season indexes"}. The information is referred to the main pollen season indexes: \emph{Start Date}, \emph{Peak Date}, \emph{End Date} and \emph{Pollen Integral}.}

\item{method}{A \code{character} string specifying the method applied to calculate the pollen season and the main seasonal parameters. The implemented methods that can be used are: \code{"percentage"}, \code{"logistic"}, \code{"moving"}, \code{"clinical"} or \code{"grains"}. By default, \code{method = "percentage"} (\code{perc = 95}\%). A more detailed information about the different methods for defining the pollen season may be consulted in the function \code{\link{calculate_ps}}.}

\item{...}{Additional arguments for the function \code{\link{calculate_ps}} are also accepted.}
}
\value{
This function returns several plots in the directory \emph{plot_AeRobiology/trend_plots} with the extension \emph{.pdf} or \emph{.png}.Also produces an object of the class \code{data.frame} and export a table with the extension \emph{.xlsx}, in the directory \emph{table_AeRobiology}.\cr
These tables have the information about the \code{slope} \emph{(beta coefficient of a lineal model using as predictor the year and as dependent variable one of the main pollen season indexes)}. The information is referred to the main pollen season indexes: \emph{Start Date}, \emph{Peak Date}, \emph{End Date} and \emph{Pollen Integral}.
}
\description{
Function to calculate the main seasonal indexes of the pollen season (\emph{Start Date}, \emph{Peak Date}, \emph{End Date} and \emph{Pollen Integral}). Trends analysis of the parameters over the seasons. Plots showing the distribution of the main seasonal indexes over the years.
}
\examples{
 data("munich_pollen")
 plot_trend(munich_pollen, interpolation = FALSE, export.plot = FALSE, export.result = TRUE)
}
\seealso{
\code{\link{calculate_ps}}; \code{\link{analyse_trend}}
}
