% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Aalen-Johansen.R
\name{aalen_johansen}
\alias{aalen_johansen}
\title{Compute the conditional Aalen-Johansen estimator.}
\usage{
aalen_johansen(
  data,
  x = NULL,
  a = NULL,
  p = NULL,
  alpha = 0.05,
  collapse = FALSE
)
}
\arguments{
\item{data}{A list of trajectory data for each individual.}

\item{x}{A numeric value for conditioning.}

\item{a}{A bandwidth. Default uses an asymmetric version using alpha.}

\item{p}{An integer representing the number of states. The absorbing state is last.}

\item{alpha}{A probability around the point x, for asymmetric sub-sampling.}

\item{collapse}{Logical, whether to collapse the last state of the model.}
}
\value{
A list containing the Aalen-Johansen estimator, the Nelson-Aalen estimator, and related quantities.
}
\description{
Compute the conditional Aalen-Johansen estimator.
}
