% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max_vorob_parallel_gpc.R
\name{max_vorob_parallel_gpc}
\alias{max_vorob_parallel_gpc}
\title{Minimizer of the parallel vorob criterion}
\usage{
max_vorob_parallel_gpc(
  lower,
  upper,
  optimcontrol = NULL,
  batchsize,
  integration.param,
  object,
  new.noise.var = 0,
  seed = NULL
)
}
\arguments{
\item{lower}{vector containing the lower bounds of the design space.}

\item{upper}{vector containing the upper bounds of the design space.}

\item{optimcontrol}{optional list of control parameters for the optimization of the sampling criterion. The field "\code{method}" defines which optimization method is used: it can be either \code{"multistart"} (default) for an optimization with \code{L-BFGS-B} multistart, or \code{"discrete"} for an optimization over a specified discrete set, or \code{"genoud"} for an optimization using the genoud algorithm. (See details)}

\item{batchsize}{number of points to sample simultaneously. The sampling criterion will return batchsize points at a time for sampling.}

\item{integration.param}{optional list of control parameter for the computation of integrals, containing the fields \code{integration.points}: a p*d matrix corresponding to p integration points. \code{integration.weights}: a vector of size p corresponding to the weights of these integration points, and \code{alpha}: the Vorob'ev threshold.}

\item{object}{an object of class \code{\link[GPCsign]{gpcm}} .}

\item{new.noise.var}{optional scalar value of the noise variance of the new observations. Default is 0.}

\item{seed}{to fix the seed.}
}
\value{
a list with components:
\item{par}{the best set of parameters found.}
\item{value}{the value of the Vorob'ev criterion at \code{par}.}
\item{allvalues}{if an optimization on a discrete set of points is chosen, the value of the criterion at all these points.}
\item{current.vorob}{current vorob’ev deviation.}
\item{alpha}{the Vorob'ev thresold.}
}
\description{
Minimization of the Vorob'ev criterion for a batch of candidate sampling points.
}
\details{
If the field \code{method} is set to \code{"genoud"}, one can set some parameters of this algorithm:
\code{pop.size}  (default: 50\emph{d),  \code{max.generations} (10}d), \code{wait.generations} (2),  \code{BFGSburnin} (2) and the mutations \code{P1}, \code{P2}, up to \code{P9} (see \code{\link[rgenoud]{genoud}}). Numbers into brackets are the default values.
If the field \code{method} is set to \code{"discrete"}, one can set the field \code{optim.points}: p * d matrix corresponding to the p points where the criterion will be evaluated. If nothing is specified, 100*d points are chosen randomly.
Finally, one can control the field \code{optim.option} in order to decide how to optimize the sampling criterion.
If \code{optim.option} is set to 2 (default), \code{batchsize} sequential optimizations in dimension d are performed to find the optimum.
If \code{optim.option} is set to 1, only one optimization in dimension \code{batchsize*d} is performed. This option is only available with \code{"genoud"}. This option might provide more global and accurate solutions, but is a lot more expensive.
}
\examples{
\donttest{
#-------------------------------------------------------------------
#------------------- max_vorob_optim_parallel_gpc-------------------
#-------------------------------------------------------------------

## 20-points DoE, and the corresponding response
d <- 2
nb_PX <- 20
x <- matrix(c(0.205293785978832, 0.0159983370750337,
              0.684774733109666, 0.125251417595962,
              0.787208786290006, 0.700475706055049,
              0.480507717105934, 0.359730889653793,
              0.543665267336735, 0.565974761807069,
              0.303412043992361, 0.471502352650857,
              0.839505250127309, 0.504914690245002,
              0.573294917143728, 0.784444726564573,
              0.291681289223421, 0.255053812451938,
              0.87233450888786, 0.947168337730927,
              0.648262257638515, 0.973264712407035,
              0.421877310273815, 0.0686662506387988,
              0.190976166753807, 0.810964668176754,
              0.918527262507395, 0.161973686467513,
              0.0188128700859558, 0.43522031347403,
              0.99902788789426, 0.655561821513544,
              0.741113863862512, 0.321050086076934,
              0.112003007565305, 0.616551317575545,
              0.383511473487687, 0.886611679106771,
              0.0749211435982952, 0.205805968972305),
            byrow = TRUE, ncol = d)
require(DiceKriging)
fx <- apply(x, 1, branin)
f <- ifelse(fx < 14, -1, 1)
Xf <- as.matrix(x)

require(future) # load future package for parallelization
plan(multisession)  # activate parallel calculations (with available cores automatic detection)
## gpcm object
require(GPCsign)
model <- gpcm(f, Xf, coef.m = -1.25, coef.cov = c(1.17,0.89))

# parameters for max_vorob_parallel_gpc function
lower <- rep(0,d)
upper <- rep(1,d)
batchsize = 1
integration.param <- list()
require(randtoolbox)
nb.integration <- d*100
integration.points <- sobol(n = nb.integration, dim = d, scrambling = 0)
integration.param$integration.points <- rep(upper-lower,each=nb.integration) *
   matrix(integration.points, nrow=nb.integration) +
   matrix(rep(lower,each=nb.integration), nrow=nb.integration)
integration.param$integration.weights <- NULL
integration.param$alpha <- NULL
optimcontrol <- list()
optimcontrol$method <- "multistart"
crit <- max_vorob_parallel_gpc(lower = lower, upper = upper,
                               batchsize = batchsize,
                               integration.param = integration.param,
                               object = model, optimcontrol = optimcontrol, seed=1)
plan(sequential) # deactivate parallel calculations: back to sequential mode 
}
}
\references{
Menz, M., Munoz-Zuniga, M., Sinoquet, D. Estimation of simulation failure set with active learning based on Gaussian Process classifiers and random set theory (2023). \url{https://hal.science/hal-03848238}.

Chevalier, C. Fast uncertainty reduction strategies relying on Gaussian process models PhD Thesis. University of Bern (2013).

Bachoc, F., Helbert, C. & Picheny, V. Gaussian process optimization with failures: classification and convergence proof. \emph{J Glob Optim} \bold{78}, 483–506 (2020). \doi{10.1007/s10898-020-00920-0}.
}
\author{
Morgane MENZ, Delphine SINOQUET, Miguel MUNOZ-ZUNIGA. Contributors: Naoual SERRAJI.
}
