% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SearchFunctions.R
\name{GetModuleList}
\alias{GetModuleList}
\title{GetModuleList}
\usage{
GetModuleList(
  type = c("all", "occurrence", "covariate", "process", "model", "output"),
  renew = FALSE
)
}
\arguments{
\item{type}{The subset of zoon modules you want to return. Defaults to 'all', but you can
select any of the zoon workflow steps: 'occurrence', 'covariate', 'process',
'model', or 'output'.}

\item{renew}{Download from github even if we already have a module list.}
}
\value{
A list with all module names.
}
\description{
Get a list of all the modules available on the github repo.
}
\details{
This function will only work on a platform that supports the
method 'libcurl' in the function url. This can be tested using the function
\code{capabilities} (see example).
}
\examples{
# GetModuleList requires libcurl to be supported
if(capabilities('libcurl')) GetModuleList()
}
