























































#[allow(non_snake_case)]
mod R;
mod call;
mod dataframe;
mod extendr_function;
mod extendr_impl;
mod extendr_module;
mod list;
mod list_struct;
mod pairlist;
mod pairs;
mod wrappers;

use proc_macro::TokenStream;
use quote::quote;
use syn::{parse_macro_input, Item};

#[proc_macro_attribute]
pub fn extendr(attr: TokenStream, item: TokenStream) -> TokenStream {
    let mut opts = wrappers::ExtendrOptions::default();

    let extendr_opts_parser = syn::meta::parser(|meta| opts.parse(meta));
    parse_macro_input!(attr with extendr_opts_parser);

    match parse_macro_input!(item as Item) {
        Item::Fn(func) => extendr_function::extendr_function(func, &opts),
        Item::Impl(item_impl) => extendr_impl::extendr_impl(item_impl),
        other_item => TokenStream::from(quote! {#other_item}),
    }
}






















#[proc_macro]
pub fn extendr_module(item: TokenStream) -> TokenStream {
    extendr_module::extendr_module(item)
}





#[proc_macro]
pub fn pairlist(item: TokenStream) -> TokenStream {
    pairlist::pairlist(item)
}





#[proc_macro]
pub fn list(item: TokenStream) -> TokenStream {
    list::list(item)
}









#[proc_macro]
pub fn call(item: TokenStream) -> TokenStream {
    call::call(item)
}










#[proc_macro]
#[allow(non_snake_case)]
pub fn R(item: TokenStream) -> TokenStream {
    R::R(item.into(), true).into()
}













#[proc_macro]
#[allow(non_snake_case)]
pub fn Rraw(item: TokenStream) -> TokenStream {
    R::R(item.into(), false).into()
}



























#[proc_macro_derive(TryFromRobj)]
pub fn derive_try_from_robj(item: TokenStream) -> TokenStream {
    list_struct::derive_try_from_robj(item)
}


































#[proc_macro_derive(IntoRobj)]
pub fn derive_into_robj(item: TokenStream) -> TokenStream {
    list_struct::derive_into_robj(item)
}






















#[proc_macro_derive(IntoDataFrameRow)]
pub fn derive_into_dataframe(item: TokenStream) -> TokenStream {
    dataframe::derive_into_dataframe(item)
}
