% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_collection_addin.R
\name{assertCollectionAddin}
\alias{assertCollectionAddin}
\title{Inserts code for a checkmate assert collection}
\usage{
assertCollectionAddin(add_comments = TRUE, insert = TRUE, indentation = NULL)
}
\arguments{
\item{add_comments}{Whether to add comments around. (Logical)

This makes it easy for a user to create their own addin without the comments.}

\item{insert}{Whether to insert the code via
\code{\link[rstudioapi:insertText]{rstudioapi::insertText()}}
or return it. (Logical)

\strong{N.B.} Mainly intended for testing the addin programmatically.}

\item{indentation}{Indentation of the code. (Numeric)

\strong{N.B.} Mainly intended for testing the addin programmatically.}
}
\value{
Inserts the following (excluding the \code{----}):

\code{----}

\code{# Check arguments ####}

\code{assert_collection <- checkmate::makeAssertCollection()}

\code{# checkmate::assert_ , add = assert_collection)}

\code{checkmate::reportAssertions(assert_collection)}

\code{# End of argument checks ####}

\code{----}

Returns \code{NULL} invisibly.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

RStudio Addin:
Inserts code for initializing and reporting a
\code{\link[checkmate:AssertCollection]{checkmate assert collection}}.

See \code{Details} for how to set a key command.
}
\details{
\subsection{How to set up a key command in RStudio}{

After installing the package.
Go to:

\code{Tools >> Addins >> Browse Addins >> Keyboard Shortcuts}.

Find \code{"Insert checkmate AssertCollection Code"} and press its field under \code{Shortcut}.

Press desired key command, e.g. \code{Alt+C}.

Press \code{Apply}.

Press \code{Execute}.
}
}
\seealso{
Other addins: 
\code{\link{dputSelectedAddin}()},
\code{\link{initializeGXSFunctionAddin}()},
\code{\link{initializeTestthatAddin}()},
\code{\link{insertExpectationsAddin}()},
\code{\link{wrapStringAddin}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{addins}
