% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_lang_alt.R
\name{as_lang_alt}
\alias{as_lang_alt}
\alias{as_lang_alt.character}
\alias{as_lang_alt.lang_alt}
\alias{as_lang_alt.list}
\title{Coerce to XMP "language alternative" structure}
\usage{
as_lang_alt(x, ...)

\method{as_lang_alt}{character}(x, ..., default_lang = getOption("xmpdf_default_lang"))

\method{as_lang_alt}{lang_alt}(x, ...)

\method{as_lang_alt}{list}(x, ..., default_lang = getOption("xmpdf_default_lang"))
}
\arguments{
\item{x}{Object suitable for coercing}

\item{...}{Ignored}

\item{default_lang}{Language tag value to copy as the "x-default"}
}
\value{
A named list of class "lang_alt".
}
\description{
\code{as_lang_alt()} coerces to an XMP "language alternative" structure
suitable for use with \code{\link[=xmp]{xmp()}} objects.
}
\examples{
  as_lang_alt("A single title")
  as_lang_alt(c(en = "An English Title", fr = "A French Title"))
  as_lang_alt(c(en = "An English Title", fr = "A French Title"), default_lang = "en")
  as_lang_alt(list(en = "An English Title", fr = "A French Title"))
}
\seealso{
\code{\link[=xmp]{xmp()}}, \code{\link[=as_xmp]{as_xmp()}}, \code{\link[=get_xmp]{get_xmp()}}, and \code{\link[=set_xmp]{set_xmp()}}.
For more information about the XMP "language alternative" structure see
\url{https://github.com/adobe/xmp-docs/blob/master/XMPNamespaces/XMPDataTypes/CoreProperties.md#language-alternative}.
}
