% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vi_boots.R
\name{vi_boots}
\alias{vi_boots}
\title{Fit and estimate variable importance from a workflow using many bootstrap resamples.}
\usage{
vi_boots(workflow, n = 2000, training_data, verbose = FALSE, ...)
}
\arguments{
\item{workflow}{An un-fitted workflow object.}

\item{n}{An integer for the number of bootstrap resampled models that will be created.}

\item{training_data}{A tibble or dataframe of data to be resampled and used for training.}

\item{verbose}{A logical. Defaults to \code{FALSE}. If set to \code{TRUE}, prints progress
of training to console.}

\item{...}{Additional params passed to \code{rsample::bootstraps()}.}
}
\value{
A tibble with a column indicating each variable in the model and a
nested list of variable importances for each variable. The shape of the list
may vary by model type. For example, linear models return two nested columns:
the absolute value of each variable's importance and the sign (POS/NEG),
whereas tree-based models return a single nested column of variable importance.
Similarly, the number of nested rows may vary by model type as some models
may not utilize every possible predictor.
}
\description{
Generate a prediction interval from arbitrary model types using bootstrap
resampling. \code{predict_boots()} generates \code{n} bootstrap resamples, fits a model
to each resample (creating \code{n} models), then creates \code{n} estimates of variable
importance for each variable in the model.
}
\details{
Since \code{vi_boots()} fits a new model to each resample, the
argument \code{workflow} must not yet be fit. Any tuned hyperparameters must be
finalized prior to calling \code{vi_boots()}.
}
\examples{
\dontrun{
library(tidymodels)

# setup a workflow without fitting
wf <-
  workflow() \%>\%
  add_recipe(recipe(qsec ~ wt, data = mtcars)) \%>\%
  add_model(linear_reg())

# fit and estimate variable importance from 125 bootstrap resampled models
set.seed(123)
wf \%>\%
  vi_boots(n = 125, training_data = mtcars)
}
}
