% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/widely_kmeans.R
\name{widely_kmeans}
\alias{widely_kmeans}
\title{Cluster items based on k-means across features}
\usage{
widely_kmeans(tbl, item, feature, value, k, fill = 0, ...)
}
\arguments{
\item{tbl}{Table}

\item{item}{Item to cluster (as a bare column name)}

\item{feature}{Feature column (dimension in clustering)}

\item{value}{Value column}

\item{k}{Number of clusters}

\item{fill}{What to fill in for missing values}

\item{...}{Other arguments passed on to \code{\link{kmeans}}}
}
\description{
Given a tidy table of features describing each item, perform k-means
clustering using \code{\link{kmeans}} and retidy the data into
one-row-per-cluster.
}
\examples{

library(gapminder)
library(dplyr)

clusters <- gapminder \%>\%
  widely_kmeans(country, year, lifeExp, k = 5)

clusters

clusters \%>\%
  count(cluster)

# Examine a few clusters
clusters \%>\% filter(cluster == 1)
clusters \%>\% filter(cluster == 2)

}
\seealso{
\code{\link{widely_hclust}}
}
