% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domain_metadata.R
\name{domain_location}
\alias{domain_location}
\title{Retrive Domain Location Information}
\usage{
domain_location(token, domain, ...)
}
\arguments{
\item{token}{a token generated with \code{\link{whoapi_token}}}

\item{domain}{a domain name}

\item{...}{further arguments to pass to httr's GET.}
}
\description{
\code{domain_location} returns geographic
information about where a domain - or, specifically,
its IP address - is located.
}
\examples{
token <- whoapi_token("demokey")
\dontrun{
location_data <- domain_location(token, "whoapi.com")
}
}
\seealso{
\code{\link{whois_info}} for more free-form information,
including (potentially) the address of the domain holders.
}

