% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{wbt_multiscale_topographic_position_image}
\alias{wbt_multiscale_topographic_position_image}
\title{Multiscale topographic position image}
\usage{
wbt_multiscale_topographic_position_image(
  local,
  meso,
  broad,
  output,
  lightness = 1.2,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{local}{Input local-scale topographic position (DEVmax) raster file.}

\item{meso}{Input meso-scale topographic position (DEVmax) raster file.}

\item{broad}{Input broad-scale topographic position (DEVmax) raster file.}

\item{output}{Output raster file.}

\item{lightness}{Image lightness value (default is 1.2).}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Creates a multiscale topographic position image from three DEVmax rasters of differing spatial scale ranges.
}
