% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lidar_analysis.R
\name{lidar_ground_point_filter}
\alias{lidar_ground_point_filter}
\title{Lidar ground point filter}
\usage{
lidar_ground_point_filter(input, output, radius = 2,
  min_neighbours = 0, slope_threshold = 45, height_threshold = 1,
  classify = TRUE, slope_norm = TRUE, verbose_mode = FALSE)
}
\arguments{
\item{input}{Input LiDAR file.}

\item{output}{Output LiDAR file.}

\item{radius}{Search Radius.}

\item{min_neighbours}{The minimum number of neighbouring points within search areas. If fewer points than this threshold are idenfied during the fixed-radius search, a subsequent kNN search is performed to identify the k number of neighbours.}

\item{slope_threshold}{Maximum inter-point slope to be considered an off-terrain point.}

\item{height_threshold}{Inter-point height difference to be considered an off-terrain point.}

\item{classify}{Classify points as ground (2) or off-ground (1).}

\item{slope_norm}{Perform initial ground slope normalization?.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is False, tools will not print output messages.}
}
\value{
Returns the tool text outputs.
}
\description{
Identifies ground points within LiDAR dataset using a slope-based method.
}
