% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alanwood.R
\name{aw_query}
\alias{aw_query}
\title{Query http://www.alanwood.net/pesticides}
\usage{
aw_query(x, type = c("commonname", "cas"), verbose = TRUE)
}
\arguments{
\item{x}{character; search string}

\item{type}{character; type of input ('cas' or 'commonname')}

\item{verbose}{logical; print message during processing to console?}
}
\value{
A list of eight entries: common-name, status, preferredd IUPAC Name,
         IUPAC Name, cas, formula, activity, subactivity, inchikey, inchi and source url.
}
\description{
Query Alan Woods Compendium of Pesticide Common Names http://www.alanwood.net/pesticides
}
\note{
for type = 'cas' only the first matched link is returned.
Please respect Copyright, Terms and Conditions \url{http://www.alanwood.net/pesticides/legal.html}!
}
\examples{
\dontrun{
aw_query('Fluazinam', type = 'commonname')
sapply(c('Fluazinam', 'Diclofop'), alanwood, type = 'com')
aw_query("79622-59-6", type = 'cas')
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}

