% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cls_wdnet.R
\name{edgelist_to_wdnet}
\alias{edgelist_to_wdnet}
\title{Creates a \code{wdnet} object using \code{edgelist}.}
\usage{
edgelist_to_wdnet(edgelist, edgeweight, directed, nodegroup, ...)
}
\arguments{
\item{edgelist}{A two-column matrix representing the edges.}

\item{edgeweight}{A numeric vector of edge weights with the same length as
the number of rows in edgelist. If \code{NULL}, all edges will be assigned
weight 1.}

\item{directed}{Logical, whether the network is directed (TRUE) or undirected
(FALSE).}

\item{nodegroup}{A numeric vector of node groups.}

\item{...}{Additional components to be added to the \code{wdnet} object.}
}
\value{
A \code{wdnet} object with the specified \code{edgelist},
  \code{edgeweight} and \code{directed}.
}
\description{
Creates a \code{wdnet} object using \code{edgelist}.
}
\examples{
edgelist <- matrix(c(1, 2, 2, 3, 3, 1), ncol = 2, byrow = TRUE)
edgeweight <- c(1, 2, 3)
nodegroup <- c(1, 1, 2)
netwk <- edgelist_to_wdnet(
  edgelist = edgelist,
  edgeweight = edgeweight,
  directed = TRUE,
  nodegroup = nodegroup
)

}
