% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/trackfreqs.R
\name{trackfreqs}
\alias{trackfreqs}
\title{Spectrograms with frequency measurements}
\usage{
trackfreqs(X, wl = 512, flim = c(0, 22), wn = "hanning", pal =
  reverse.gray.colors.2, ovlp = 70, inner.mar = c(5, 4, 4, 2), outer.mar =
  c(0, 0, 0, 0), picsize = 1, res = 100, cexlab = 1, title = TRUE, propwidth = FALSE,
  xl = 1, osci = FALSE, gr = FALSE, sc = FALSE, bp = c(0, 22), cex = c(0.8, 1),
  threshold = 15, col = c("chartreuse3", "dodgerblue"), pch = c(17, 16),  mar = 0.05,
  lpos = "topright", it = "jpeg", parallel = FALSE)
}
\arguments{
\item{X}{Data frame with results containing columns for sound file name (sound.files),
selection number (selec), and start and end time of signal (start and end).
The ouptut of \code{\link{manualoc}} or \code{\link{autodetec}} can be used as the input data frame.}

\item{wl}{A numeric vector of length 1 specifying the window length of the spectrogram, default
is 512.}

\item{flim}{A numeric vector of length 2 for the frequency limit of
the spectrogram (in kHz), as in \code{\link[seewave]{spectro}}. Default is c(0, 22).}

\item{wn}{Character vector of length 1 specifying window name. Default is
"hanning". See function \code{\link[seewave]{ftwindow}} for more options.}

\item{pal}{A color palette function to be used to assign colors in the
plot, as in \code{\link[seewave]{spectro}}. Default is reverse.gray.colors.2.}

\item{ovlp}{Numeric vector of length 1 specifying \% of overlap between two
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 70.}

\item{inner.mar}{Numeric vector with 4 elements, default is c(5,4,4,2).
Specifies number of lines in inner plot margins where axis labels fall,
with form c(bottom, left, top, right). See \code{\link[graphics]{par}}.}

\item{outer.mar}{Numeric vector with 4 elements, default is c(0,0,0,0).
Specifies number of lines in outer plot margins beyond axis labels, with
form c(bottom, left, top, right). See \code{\link[graphics]{par}}.}

\item{picsize}{Numeric argument of length 1. Controls relative size of
spectrogram. Default is 1.}

\item{res}{Numeric argument of length 1. Controls image resolution.
Default is 100 (faster) although 300 - 400 is recommended for publication/
presentation quality.}

\item{cexlab}{Numeric vector of length 1 specifying the relative size of axis
labels. See \code{\link[seewave]{spectro}}.}

\item{title}{Logical argument to add a title to individual spectrograms.
Default is \code{TRUE}.}

\item{propwidth}{Logical argument to scale the width of spectrogram
proportionally to duration of the selected call. Default is \code{FALSE}.}

\item{xl}{Numeric vector of length 1. A constant by which to scale
spectrogram width. Default is 1.}

\item{osci}{Logical argument to add an oscillogram underneath spectrogram, as
in \code{\link[seewave]{spectro}}. Default is \code{FALSE}.}

\item{gr}{Logical argument to add grid to spectrogram. Default is \code{FALSE}.}

\item{sc}{Logical argument to add amplitude scale to spectrogram, default is
\code{FALSE}.}

\item{bp}{A numeric vector of length 2 for the lower and upper limits of a
frequency bandpass filter (in kHz). Default is c(0, 22).}

\item{cex}{Numeric vector of length 1, specifies relative size of points
plotted for frequency measurements and legend font/points, respectively.
See \code{\link[seewave]{spectro}}.}

\item{threshold}{amplitude threshold (\%) for fundamental frequency and
dominant frequency detection. Default is 15.}

\item{col}{Vector of length 2 specifying colors of points plotted to mark
fundamental and dominant frequency measurements. Default is c("chartreuse3",
"dodgerblue").}

\item{pch}{Numeric vector of length 2 specifying plotting characters for
the frequency measurements. Default is c(17, 16).}

\item{mar}{Numeric vector of length 1. Specifies the margins adjacent to the selections
to set spectrogram limits. Default is 0.05.}

\item{lpos}{Character vector of length 1 or numeric vector of length 2,
specifiying position of legend. If the former, any keyword accepted by
xy.coords can be used (see below). If the latter, the first value will be the x
coordinate and the second value the y coordinate for the legend's position.
Default is "topright".}

\item{it}{A character vector of length 1 giving the image type to be used. Currently only
"tiff" and "jpeg" are admitted. Default is "jpeg".}

\item{parallel}{Either logical or numeric. Controls wehther parallel computing is applied.
If \code{TRUE} 2 cores are employed. If numeric, it specifies the number of cores to be used.
Not available for windows OS.}
}
\value{
Spectrograms of the signals listed in the input data frame showing the location of
the dominant and fundamental frequencies.
}
\description{
\code{trackfreqs} creates spectrograms to visualize dominant and fundametal frequency measurements
of signals selected by \code{\link{manualoc}} or \code{\link{autodetec}}.
}
\details{
This function provides visualization of frequency measurements
  made by \code{\link{specan}}. Arguments that are accepted by xy.coords and can be
  used for lpos are: "bottomright", "bottom", "bottomleft", "left",
  "topleft", "top", "topright", "right" and "center". Setting inner.mar to
  c(4,4.5,2,1) and outer.mar to c(4,2,2,1) works well when picsize = 2 or 3.
  Title font size, inner.mar and outer.mar (from mar and oma) don't work well
  when osci or sc = TRUE, this may take some optimization by the user.
}
\examples{
\dontrun{
#First create empty folder
dir.create(file.path(getwd(),"temp"))
setwd(file.path(getwd(),"temp"))

#load data
data(list = c("Phae.long1", "Phae.long2"))
data(manualoc.df)
writeWave(Phae.long2, "Phae.long2.wav") #save sound files
writeWave(Phae.long1, "Phae.long1.wav")

# make  spectrograms

trackfreqs(manualoc.df, flim = c(0, 14), inner.mar = c(4,4.5,2,1), outer.mar = c(4,2,2,1),
picsize = 2, res = 300, cexlab = 2, bp = c(0, 14), cex = c(1.5, 2),
col = c("blue", "red"),  mar = 0.09, lpos = "bottomright", it = "jpeg")

# make only Phae.long1 spectrograms

trackfreqs(manualoc.df[manualoc.df$sound.files == "Phae.long1.wav", ], flim = c(3, 14),
inner.mar = c(4,4.5,2,1), outer.mar = c(4,2,2,1), picsize = 2, res = 300, cexlab = 2,
bp = c(3, 14), cex = c(1.5, 2), col = c("blue", "red"),  mar = 0.09,
lpos = "bottomright", it = "tiff")

# remove example directory
unlink(getwd(),recursive = TRUE)
}
}
\author{
Grace Smith Vidaurre and Marcelo Araya-Salas (\url{http://marceloarayasalas.weebly.com/})
}
\seealso{
\code{\link{specreator}} for creating spectrograms from selections,
 \code{\link{snrspecs}} for creating spectrograms to
  optimize noise margins used in \code{\link{sig2noise}}

Other spectrogram.creators: \code{\link{dfts}};
  \code{\link{snrspecs}}; \code{\link{specreator}}
}

