% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polar_coords.R
\name{calc_pvals}
\alias{calc_pvals}
\title{Calculate one-way test and pairwise tests}
\usage{
calc_pvals(
  outcome,
  data,
  pcutoff = 0.05,
  padj.method = "BH",
  group_test = c("anova", "kruskal.test"),
  pairwise_test = c("t.test", "wilcoxon"),
  exact = FALSE,
  filter_pairwise = TRUE
)
}
\arguments{
\item{outcome}{Outcome vector with 3 groups, ideally as a factor. If it is
not a factor, this will be coerced to a factor. This must have exactly 3
levels.}

\item{data}{Dataframe or matrix with variables in columns}

\item{pcutoff}{Cut-off for p-value significance}

\item{padj.method}{Can be any method available in `p.adjust` or `"qvalue"`.
The option "none" is a pass-through.}

\item{group_test}{Specifies statistical test for 3-class group comparison.
"anova" means one-way ANOVA, "kruskal.test" means Kruskal-Wallis test.}

\item{pairwise_test}{Specifies statistical test for pairwise comparisons}

\item{exact}{Logical which is only used with `pairwise_test = "wilcoxon"`}

\item{filter_pairwise}{Logical. If `TRUE` (the default) p-value adjustment on
pairwise statistical tests is only conducted on attributes which reached
the threshold for significance after p-value adjustment on the group
statistical test.}
}
\description{
Internal function for calculating 3-class group test (either one-way ANOVA or
Kruskal-Wallis test) and pairwise tests (either t-test or Wilcoxon test) on
multi-column data against an outcome parameter with 3 levels.
}
