% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot-method.R, R/ggplot.lmfit.R
\name{ggplot-method}
\alias{ggplot-method}
\alias{ggplot.lmfit}
\title{Plot functions}
\usage{
\method{ggplot}{lmfit}(x, y, ..., environment = parent.frame())
}
\arguments{
\item{x, y}{Two vectors}

\item{...}{Other arguments passed on to methods. Not currently used.}

\item{environment}{If an variable defined in the aesthetic mapping is not
found in the data, ggplot will look for it in this environment. It defaults
to using the environment in which \code{ggplot()} is called.}
}
\value{
\item{p}{Returns a ggplot object.}
}
\description{
This functions plots model fit using ggplot.
}
\details{
Visualization of linear fit (y = ax + b), using scatter plots and with regression line, as well as
added details of regression equation and R^2.
}
\examples{
library(visa)
x <- 1:10
y <- 2:11+0.5
ggplot.lmfit(x, y)

}
