% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tv2vegtable.R
\name{tv2vegtable}
\alias{tv2vegtable}
\alias{tv2coverconvert}
\title{Import of vegetation data from Turboveg databases}
\usage{
tv2vegtable(
  db,
  tv_home = tv.home(),
  skip_empty_relations = TRUE,
  skip_scale,
  clean = TRUE
)

tv2coverconvert(file, as.is = TRUE)
}
\arguments{
\item{db}{Name of \strong{Turboveg} data base as character value.}

\item{tv_home}{\strong{Turboveg} installation path as character value.}

\item{skip_empty_relations}{Logical value indicating whether empty relations
may be excluded from imported database or not.}

\item{skip_scale}{Character value indicating scales to be excluded in slot
\code{coverconvert}.}

\item{clean}{Logical value indicating whether output object should be
cleaned or not.}

\item{file}{A connection to a DBF file containing conversion table in
\strong{Turboveg}.}

\item{as.is}{A logical value passed to \code{\link[=read.dbf]{read.dbf()}}.}
}
\value{
A \linkS4class{vegtable} object in the case of \code{tv2vegtable()}.
A \linkS4class{coverconvert} object in the case of \code{tv2coverconvert()}.
}
\description{
Import function for \strong{Turboveg} databases into an object of class
\linkS4class{vegtable}.
Most of the contents of \strong{Turboveg} databases are included in DBF files and
therefore imported by the function \code{\link[foreign:read.dbf]{foreign::read.dbf()}}.
The automatic setting of database path will be done by the function
\code{\link[vegdata:vegdata-internal]{vegdata::tv.home()}} but it can be customised by the argument \code{tv_home}.

The species list will be imported by using the function
\code{\link[taxlist:tv2taxlist]{taxlist::tv2taxlist()}} and therefore formatted as a \linkS4class{taxlist} object.
Similarly, conversion tables will be handled as \linkS4class{coverconvert} objects.

Empty columns in the header will be deleted in the imported object.

The function \code{tv2coverconvert()} reads the content of cover conversion
tables stored in \strong{Turboveg} and attempts to reformat them in a more
comprehensive structure.

This function is used by \code{tv2vegtable()} to import the respective
conversion table from \strong{Turboveg} databases.
Note that conversion tables in \strong{Turboveg} have only stored the middle
point for each cover class in a scale, thus it will be recommended to
rebuild the \code{coverconvert} slot or use \link{braun_blanquet}.
}
\examples{
## Installed 'Turboveg' version of 'Fujiwara et al. (2014)'
TV_Home <- file.path(path.package("vegtable"), "tv_data")
Veg <- tv2vegtable("Fujiwara_2014", TV_Home)
summary(Veg)

## Installed 'Turboveg' version of "Fujiwara et al. (2014)"
TV_Home <- file.path(path.package("vegtable"), "tv_data", "popup", "Swea")
Table <- tv2coverconvert(file.path(TV_Home, "tvscale.dbf"))

## First scale have to be deleted from conversion table
Table@value <- Table@value[-1]
Table@conversion <- Table@conversion[-1]
summary(Table)

## Compare the 'Turboveg' version with a vegtable version
data(braun_blanquet)
summary(Table$br_bl)
summary(braun_blanquet$br_bl)

}
\seealso{
\code{\link[taxlist:tv2taxlist]{taxlist::tv2taxlist()}} \code{\link[foreign:read.dbf]{foreign::read.dbf()}} \code{\link[vegdata:vegdata-internal]{vegdata::tv.home()}}
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
