% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_handler-httr.R
\docType{data}
\name{RequestHandlerHttr}
\alias{RequestHandlerHttr}
\title{RequestHandlerHttr - methods for httr package}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
RequestHandlerHttr
}
\description{
RequestHandlerHttr - methods for httr package
}
\details{
\strong{Public Methods}
\describe{
\item{\code{handle(request)}}{
Top level function to interaction with. Handle the request
}
}

\strong{Private Methods}
\describe{
\item{\code{request_type(request)}}{
Get the request type
}
\item{\code{externally_stubbed()}}{
just returns FALSE
}
\item{\code{should_ignore()}}{
should we ignore the request, depends on request ignorer
infrastructure that's not working yet
}
\item{\code{has_response_stub()}}{
Check if there is a matching response stub in the
http interaction list
}
\item{\code{get_stubbed_response()}}{
Check for a response and get it
}
\item{\code{request_summary(request)}}{
get a request summary
}
\item{\code{on_externally_stubbed_request(request)}}{
on externally stubbed request do nothing
}
\item{\code{on_ignored_request(request)}}{
on ignored request, do something
}
\item{\code{on_recordable_request(request)}}{
on recordable request, record the request
}
\item{\code{on_unhandled_request(request)}}{
on unhandled request, run UnhandledHTTPRequestError
}
}
}
\examples{
\dontrun{
vcr_configure(
 dir = tempdir(),
 record = "once"
)

library(httr)
load("~/httr_req.rda")
req
x <- RequestHandlerHttr$new(req)
# x$handle()
}
}
\keyword{datasets}
