% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_se.R
\name{se.tetra}
\alias{se.tetra}
\title{Computes the standard error for a tetrachoric correlation approximation}
\usage{
se.tetra(f00, f01, f10, f11)
}
\arguments{
\item{f00}{number of participants with y = 0 and x = 0}

\item{f01}{number of participants with y = 0 and x = 1}

\item{f10}{number of participants with y = 1 and x = 0}

\item{f11}{number of participants with y = 1 and x = 1}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated tetrachoric approximation
\item SE - standard error
}
}
\description{
This function can be used to compute an estimate of a tetrachoric
correlation approximation and its standard error using the frequency counts
from a 2 x 2 contingency table for two artifically dichotomous variables.
A tetrachoric approximation could be compatible with a Pearson correlation
in a meta-analysis. The tetrachoric approximation and the standard error
from this function can be used as input in the \link[vcmeta]{meta.ave.gen}
function in a meta-analysis where some studies have reported Pearson
correlations between quantitative variables x and y and other studies have
reported a 2 x 2 contingency table for dichotomous measurements of variables
x and y.
}
\examples{
se.tetra(46, 15, 54, 85)

# Should return:
#                Estimate         SE 
# Tetrachoric:  0.5135167 0.09358336


}
\references{
\insertRef{Bonett2005}{vcmeta}
}
