% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_model.R
\name{meta.lm.semipart}
\alias{meta.lm.semipart}
\title{Meta-regression analysis for semipartial correlations}
\usage{
meta.lm.semipart(alpha, n, cor, r2, X)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{n}{vector of sample sizes}

\item{cor}{vector of estimated semipartial correlations}

\item{r2}{vector of estimated squared multiple correlations for full model}

\item{X}{matrix of predictor values}
}
\value{
Returns a matrix.  The first row is for the intercept with one additional
row per predictor.  The matrix has the following columns:
\itemize{
\item Estimate - OLS estimate
\item SE - standard error
\item z - z-value
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
This function estimates the intercept and slope coefficients in a
meta-regression model where the dependent variable is a Fisher-transformed
semipartial correlation. The estimates are OLS estimates with robust
standard errors that accommodate residual heteroscedasticity.  The
correlations are Fisher-transformed and hence the parameter estimates
do not have a simple interpretation. However, the hypothesis test results
can be used to decide if a population slope is either positive or negative.
}
\examples{

n <- c(128, 97, 210, 217)
cor <- c(.35, .41, .44, .39)
r2 <- c(.29, .33, .36, .39)
x1 <- c(18, 25, 23, 19)
X <- matrix(x1, 4, 1)
meta.lm.semipart(.05, n, cor, r2, X)

# Should return: 
#      Estimate        SE         z     p          LL         UL
# b0 0.19695988 0.3061757 0.6432905 0.520 -0.40313339 0.79705315
# b1 0.01055584 0.0145696 0.7245114 0.469 -0.01800004 0.03911172


}
