% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq_peak_plot.R
\name{freq_peak_plot}
\alias{freq_peak_plot}
\title{Plot freq_peak object}
\usage{
freq_peak_plot(pos, posUnits = "bp", ab1 = NULL, ab2 = NULL, fp1 = NULL,
  fp2 = NULL, mySamp = 1, col1 = "#A6CEE3", col2 = "#1F78B4",
  alpha = 44, main = NULL, mhist = TRUE, layout = TRUE, ...)
}
\arguments{
\item{pos}{chromosomal position of variants}

\item{posUnits}{units ('bp', 'Kbp', 'Mbp', 'Gbp') for `pos` to be converted to in the main plot}

\item{ab1}{matrix of allele balances for allele 1}

\item{ab2}{matrix of allele balances for allele 2}

\item{fp1}{feq_peak object for allele 1}

\item{fp2}{feq_peak object for allele 2}

\item{mySamp}{sample indicator}

\item{col1}{color 1}

\item{col2}{color 2}

\item{alpha}{sets the transparency for dot plot (0-255)}

\item{main}{main plot title.}

\item{mhist}{logical indicating to include a marginal histogram}

\item{layout}{call layout}

\item{...}{parameters passed on to other functions}
}
\value{
An invisible NULL.
}
\description{
Converts allele balance data produced by \code{freq_peak()} to a copy number by assinging the allele balance data (frequencies) to its closest expected ratio.
}
\details{
Creates a visualization of allele balance data consisting of a dot plot with position as the x-axis and frequency on the y-axis and an optional marginal histogram.
The only required information is a vector of chromosomal positions, however this is probably not going to create an interesting plot.
}
\examples{

# An empty plot.
freq_peak_plot(pos=1:40)

data(vcfR_example)
gt <- extract.gt(vcf)
hets <- is_het(gt)
# Censor non-heterozygous positions.
is.na(vcf@gt[,-1][!hets]) <- TRUE
# Extract allele depths.
ad <- extract.gt(vcf, element = "AD")
ad1 <- masplit(ad, record = 1)
ad2 <- masplit(ad, record = 2)
freq1 <- ad1/(ad1+ad2)
freq2 <- ad2/(ad1+ad2)
myPeaks1 <- freq_peak(freq1, getPOS(vcf))
is.na(myPeaks1$peaks[myPeaks1$counts < 20]) <- TRUE
myPeaks2 <- freq_peak(freq2, getPOS(vcf), lhs = FALSE)
is.na(myPeaks2$peaks[myPeaks2$counts < 20]) <- TRUE
freq_peak_plot(pos = getPOS(vcf), ab1 = freq1, ab2 = freq2, fp1 = myPeaks1, fp2=myPeaks2)



}
\seealso{
freq_peak,
peak_to_ploid
}
