% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq5d.R
\name{value3LInd}
\alias{value3LInd}
\title{Function to value EQ-5D-3L scores for various countries}
\usage{
value3LInd(country, method, dimen, dimen2 = NA, dimen3 = NA,
  dimen4 = NA, dimen5 = NA)
}
\arguments{
\item{country}{a country name from the list Belgium,Brazil,Canada,Chile,Denmark,Europe,Finland,France,Germany,Italy,Japan,Korea,Netherlands,NewZealand,Poland,Portugal,Slovenia,Spain,Taiwan,Thailand,UK,USA,and Zimbabwe}

\item{method}{method name either TTO or VAS}

\item{dimen}{a must input,response for EQ-5D-5L mobility  or the 5 digit response, or the vector of responses, e.g. 11111, c(1,1,1,1,1) or 1}

\item{dimen2}{response for EQ-5D-3L self care, or NA if the responses are given as dimen}

\item{dimen3}{response for EQ-5D-3L usual activities,or NA if the responses are given as dimen}

\item{dimen4}{response for EQ-5D-3L pain/discomfort, or NA if the responses are given as dimen}

\item{dimen5}{response for EQ-5D-3L anxiety/depression, or NA if the responses are given as dimen}
}
\value{
index value based if success, negative values for failure
}
\description{
Function to value EQ-5D-3L scores for various countries
}
\examples{
value3LInd("UK", "TTO", 23131)
value3LInd("Spain", "TTO", 2, 3, 1, 3, 1)
value3LInd("Denmark", "VAS", c(1, 2, 3, 1, 3))
}
