% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_baseline.R
\name{baseline}
\alias{baseline}
\title{Baseline reference for multilabel classification}
\usage{
baseline(mdata, metric = c("general", "F1", "hamming-loss", "subset-accuracy",
  "ranking-loss"), ...)
}
\arguments{
\item{mdata}{A mldr dataset used to train the binary models.}

\item{metric}{Define the strategy used to predict the labels.

 The possible values are: \code{'general'}, \code{'F1'},
 \code{'hamming-loss'} or \code{'subset-accuracy'}. See the description
 for more details. (Default: \code{'general'}).}

\item{...}{not used}
}
\value{
An object of class \code{BASELINEmodel} containing the set of fitted
  models, including:
  \describe{
   \item{labels}{A vector with the label names.}
   \item{predict}{A list with the labels that will be predicted.}
  }
}
\description{
Create a baseline model for multilabel classification.
}
\details{
Baseline is a naive multi-label classifier that maximize/minimize a specific
measure without induces a learning model. It uses the general information
about the labels in training dataset to estimate the labels in a test
dataset.

The follow strategies are available:
\describe{
 \item{\code{general}}{Predict the k most frequent labels, where k is the
  integer most close of label cardinality.}
 \item{\code{F1}}{Predict the most frequent labels that obtain the best F1
  measure in training data. In the original paper, the authors use the less
  frequent labels.}
 \item{\code{hamming-loss}}{Predict the labels that are associated with more
  than 50\% of instances.}
 \item{\code{subset-accuracy}}{Predict the most common labelset.}
 \item{\code{ranking-loss}}{Predict a ranking based on the most frequent
  labels.}
}
}
\examples{
model <- baseline(toyml)
pred <- predict(model, toyml)

## Change the metric
model <- baseline(toyml, "F1")
model <- baseline(toyml, "subset-accuracy")
}
\references{
Metz, J., Abreu, L. F. de, Cherman, E. A., & Monard, M. C. (2012). On the
 Estimation of Predictive Evaluation Measure Baselines for Multi-label
 Learning. In 13th Ibero-American Conference on AI (pp. 189-198).
 Cartagena de Indias, Colombia.
}
