% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threshold.R
\name{subset_correction}
\alias{subset_correction}
\title{Subset Correction of a predicted result}
\usage{
subset_correction(mlresult, train_y, base.threshold = NULL,
  probability = FALSE)
}
\arguments{
\item{mlresult}{An object of mlresult that contain the scores and bipartition
values.}

\item{train_y}{A matrix/data.frame with all labels values of the training
dataset or a mldr train dataset.}

\item{base.threshold}{A numeric value between 0 and 1 to use as base to
determine which values needs be reescaled to preserve the corrected
labelsets. If \code{NULL} the score correction is ignored. (Default: NULL)}

\item{probability}{A logical value. If \code{TRUE} the predicted values are
the score between 0 and 1, otherwise the values are bipartition 0 or 1.
(Default: \code{FALSE})}
}
\value{
A new mlresult where all results are present in the training
 labelsets.
}
\description{
This method restrict a multi-label learner to predict only label combinations
whose existence is present in the (training) data. To this all labelsets
that are predicted but are not found on training data is replaced by the most
similar labelset.
}
\details{
If the most simillar is not unique, those label combinations with higher
frequency in the training data are preferred. The Hamming loss distance is
used to determine the difference between the labelsets.
}
\note{
The original paper describes a method to create only bipartitions
 result, but we adapeted the method to change the scores. Based on the
 base.threshold value the scores higher than the threshold value, but must be
 lower are changed to respect this restriction. If \code{NULL} this
 correction will be ignored.
}
\examples{
prediction <- predict(br(toyml, "RANDOM"), toyml)
subset_correction(prediction, toyml)
}
\references{
Senge, R., Coz, J. J. del, & Hullermeier, E. (2013). Rectifying classifier
   chains for multi-label classification. In Workshop of Lernen, Wissen &
   Adaptivitat (LWA 2013) (pp. 162-169). Bamberg, Germany.
}
\seealso{
Other threshold: \code{\link{fixed_threshold}},
  \code{\link{mcut_threshold}},
  \code{\link{pcut_threshold}},
  \code{\link{rcut_threshold}},
  \code{\link{scut_threshold}}
}

