% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vignette.R
\name{use_vignette}
\alias{use_vignette}
\alias{use_article}
\title{Create a vignette or article.}
\usage{
use_vignette(name, title = name)

use_article(name, title = name)
}
\arguments{
\item{name}{Base for file name to use for new vignette. Should consist only
of numbers, letters, \code{_} and \code{-}. Lower case is recommended.}

\item{title}{The title of the vignette.}
}
\description{
Creates a new vignette or article in \code{vignettes/}. Articles are a special
type of vignette that appear on pkgdown websites, but are not included
in the package itself (because they are added to \code{.Rbuildignore}
automatically).
}
\section{General setup}{

\itemize{
\item Adds needed packages to \code{DESCRIPTION}.
\item Adds \code{inst/doc} to \code{.gitignore} so built vignettes aren't tracked.
\item Adds \code{vignettes/*.html} and \code{vignettes/*.R} to \code{.gitignore} so
you never accidentally track rendered vignettes.
}
}

\examples{
\dontrun{
use_vignette("how-to-do-stuff", "How to do stuff")
}
}
\seealso{
The \href{http://r-pkgs.had.co.nz/vignettes.html}{vignettes chapter} of
\href{http://r-pkgs.had.co.nz}{R Packages}.
}
