% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rstudio.R
\name{use_blank_slate}
\alias{use_blank_slate}
\title{Don't save/load user workspace between sessions}
\usage{
use_blank_slate(scope = c("user", "project"))
}
\arguments{
\item{scope}{Edit globally for the current \strong{user}, or locally for the
current \strong{project}}
}
\description{
R can save and reload the user's workspace between sessions via an \code{.RData}
file in the current directory. However, long-term reproducibility is enhanced
when you turn this feature off and clear R's memory at every restart.
Starting with a blank slate provides timely feedback that encourages the
development of scripts that are complete and self-contained. More detail can
be found in the blog post \href{https://www.tidyverse.org/articles/2017/12/workflow-vs-script/}{Project-orientedworkflow}.
}
\details{
Only \code{use_blank_slate("project")} is automated so far, since RStudio
currently only supports modification of user-level or global options via the
user interface.
}
