% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cospect.R
\name{cospect}
\alias{cospect}
\title{Calculate the cospectrum between all pairs of time series}
\usage{
cospect(X)
}
\arguments{
\item{X}{a matrix with counts or densities arranged in species by time step.}
}
\value{
\code{cospect} return a list with elements
\item{frequency}{a vector from 0 to 1 of the frequencies used}
\item{cospectrum}{a 3D array, with cospectrum range in species by species by frequency}
}
\description{
This function is used to calculate the cospectra between pairs of time series,
including each time series with itself. These are based on simple ffts without
smoothing.
}
\examples{
X<-matrix(runif(200,1,100), 10, 20)
ans<-cospect(X)

}
\author{
Lei Zhao, \email{lei.zhao@cau.edu.cn}; Daniel Reuman, \email{reuman@ku.edu}
}
