% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valmod.R
\name{valmod}
\alias{valmod}
\title{Variable Length Motif Discovery}
\usage{
valmod(
  ...,
  window_min,
  window_max,
  heap_size = 50,
  exclusion_zone = getOption("tsmp.exclusion_zone", 1/2),
  lb = TRUE,
  verbose = getOption("tsmp.verbose", 2)
)
}
\arguments{
\item{\dots}{a \code{matrix} or a \code{vector}. If a second time series is supplied it will be a join matrix
profile.}

\item{window_min}{an \code{int}. Minimum size of the sliding window.}

\item{window_max}{an \code{int}. Maximum size of the sliding window.}

\item{heap_size}{an \code{int}. (Default is \code{50}). Size of the distance profile heap buffer}

\item{exclusion_zone}{a \code{numeric}. Size of the exclusion zone, based on window size (default is
\code{1/2}). See details.}

\item{lb}{a \code{logical}. (Default is \code{TRUE}). If \code{FALSE} all window sizes will be calculated using
STOMP instead of pruning. This is just for academic purposes.}

\item{verbose}{an \code{int}. See details. (Default is \code{2}).}
}
\value{
Returns a \code{Valmod} object, a \code{list} with the matrix profile \code{mp}, profile index \code{pi}
left and right matrix profile \code{lmp}, \code{rmp} and profile index \code{lpi}, \code{rpi}, best window size \code{w}
for each index and exclusion zone \code{ez}. Additionally: \code{evolution_motif} the best motif distance
per window size, and non-length normalized versions of \code{mp}, \code{pi} and \code{w}: \code{mpnn}, \code{pinn} and \code{wnn}.
}
\description{
Computes the Matrix Profile and Profile Index for a range of query window sizes
}
\details{
This algorithm uses an exact algorithm based on a novel lower bounding technique, which is
specifically designed for the motif discovery problem. \code{verbose} changes how much information
is printed by this function; \code{0} means nothing, \code{1} means text, \code{2} adds the progress bar,
\code{3} adds the finish sound. \code{exclusion_zone} is used to avoid  trivial matches; if a query data
is provided (join similarity), this parameter is ignored.

Paper that implements \code{skimp()} suggests that window_max / window_min > than 1.24 begins to
weakening pruning in \code{valmod()}.
}
\examples{
mp <- valmod(mp_toy_data$data[1:200, 1], window_min = 30, window_max = 40, verbose = 0)
\dontrun{
ref_data <- mp_toy_data$data[, 1]
query_data <- mp_toy_data$data[, 2]
# self similarity
mp <- valmod(ref_data, window_min = 30, window_max = 40)
# join similarity
mp <- valmod(ref_data, query_data, window_min = 30, window_max = 40)
}

}
\references{
\itemize{
\item Linardi M, Zhu Y, Palpanas T, Keogh E. VALMOD: A Suite for Easy and Exact Detection
of Variable Length Motifs in Data Series. In: Proceedings of the 2018 International Conference
on Management of Data - SIGMOD '18. New York, New York, USA: ACM Press; 2018. p. 1757-60.
}

Website: \url{http://www.cs.ucr.edu/~eamonn/MatrixProfile.html}
}
\seealso{
Other matrix profile computations: 
\code{\link{mstomp_par}()},
\code{\link{scrimp}()},
\code{\link{stamp_par}()},
\code{\link{stomp_par}()},
\code{\link{tsmp}()}
}
\concept{matrix profile computations}
