% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VAR.sim.R
\name{VAR.sim}
\alias{VAR.sim}
\alias{VAR.boot}
\title{Simulate or bootstrap a VAR model}
\usage{
VAR.sim(
  B,
  n = 200,
  lag = 1,
  include = c("const", "trend", "none", "both"),
  starting = NULL,
  innov = rmnorm(n, varcov = varcov),
  varcov = diag(1, nrow(B)),
  show.parMat = FALSE,
  returnStarting = FALSE,
  ...
)

VAR.boot(
  VARobject,
  boot.scheme = c("resample", "wild1", "wild2", "check"),
  seed,
  ...
)
}
\arguments{
\item{B}{Matrix of coefficients.}

\item{n}{Number of observations to simulate}

\item{lag}{Number of lags of the VAR to simulate}

\item{include}{Type of deterministic regressors to include in the VAR to simulate}

\item{starting}{Starting values (matrix of dimension lag x k) for the VAR to simulate. If not given,
set to zero.}

\item{innov}{Innovations used for in the VAR to simulate. Should be matrix of dim n x k.
By default multivariate normal.}

\item{varcov}{Variance-covariance matrix for the innovations. By default
identity matrix.}

\item{show.parMat}{Logical. Should the parameter matrix be shown? Useful to
understand how to give right input}

\item{returnStarting}{Whether starting values are returned. Default to FALSE}

\item{\dots}{Further arguments passed to the underlying (un-exported)
\code{VAR.gen} function}

\item{VARobject}{Object of class \code{ VAR} generated by function
\code{\link{lineVar}}}

\item{boot.scheme}{The bootstrap scheme. See details.}

\item{seed}{Optional. Seed for the random resampling function.}
}
\value{
A matrix with the resampled series.
}
\description{
Allow to either simulate from scratch (by providing coefficients) or bootstrap from an estimated VAR model,
}
\details{
For the bootstrap, the function resamples data from a given VAR model generated by
\code{\link{lineVar}}, returning the resampled data. 
A residual recursive bootstrap is used, where one uses either a simple
resampling, or the Wild bootstrap, either with a normal distribution (wild1) or
inverting the sign randomly (wild2)
}
\examples{

## VAR.sim: simulate VAR as in Enders 2004, p 268
B1<-matrix(c(0.7, 0.2, 0.2, 0.7), 2)
var1 <- VAR.sim(B=B1, n=100, include="none")
ts.plot(var1, type="l", col=c(1,2))


B2<-rbind(c(0.5, 0.5, 0.5), c(0, 0.5, 0.5))
varcov<-matrix(c(1,0.2, 0.3, 1),2)
var2 <- VAR.sim(B=B2, n=100, include="const", varcov=varcov)
ts.plot(var2, type="l", col=c(1,2))

## VAR.boot: Bootstrap a VAR 
data(zeroyld)
mod <- lineVar(data=zeroyld,lag=1)
VAR.boot(mod)


}
\seealso{
\code{\link{lineVar}} to estimate the VAR.  Similar \code{\link{TVECM.sim}} and \code{\link{TVECM.boot}} for \code{\link{TVECM}}, 
\code{\link{TVAR.sim}} and \code{\link{TVAR.boot}} for \code{\link{TVAR}} models.
}
\author{
Matthieu Stigler
}
\keyword{bootstrap}
\keyword{ts}
