\name{irf}

\alias{irf}

\alias{print.varirf}

\alias{irf.nlVar}



\title{Impulse response function}

\encoding{latin1}

\description{
  Use the \code{fevd} function from package \pkg{vars} to tompute the impulse response coefficients 
  of a VAR(p) (or transformed VECM to VAR(p)) for \code{n.ahead} steps. 
}

\usage{
\method{irf}{nlVar}(x, impulse = NULL, response = NULL, n.ahead = 10,
ortho = TRUE, cumulative = FALSE, boot = TRUE, ci = 0.95,
runs = 100, seed = NULL, ...)
}

\arguments{
  \item{x}{
	    Object of class \sQuote{\code{VAR}}; generated by \command{lineVar()}, 
	    or object of class \sQuote{\code{VECM}}; generated by\command{VECM()}.
  }  
  \item{impulse}{A character vector of the impulses, default is all
    variables.}  
  \item{response}{A character vector of the responses, default is all
    variables.}  
  \item{n.ahead}{Integer specifying the steps.}
  \item{ortho}{Logical, if \code{TRUE} (the default) the orthogonalised impulse
    response coefficients are computed (only for objects of class
    \sQuote{\code{varest}}).}    
  \item{cumulative}{Logical, if \code{TRUE} the cumulated
    impulse response coefficients are computed. The default value is false.}  
  \item{boot}{Logical, if \code{TRUE} (the default) bootstrapped error
    bands for the imuplse response coefficients are computed.}  
  \item{ci}{Numeric, the confidence interval for the bootstrapped errors
    bands.}
  \item{runs}{An integer, specifying the runs for the bootstrap.}
  \item{seed}{An integer, specifying the seed for the \code{rng} of the
    bootstrap.}
  \item{...}{Currently not used.}
}

\details{
  The function converts the VAR or VECM computed by package tsDyn into 
  an object of class \sQuote{\code{vec2var}}, on which then the \code{\link[vars]{irf}}
  method is applied. For details, see the relevant package.
  
}
\value{
  A list of class \sQuote{\code{varirf}} with the following elements is
  returned:\cr
  
  \item{irf}{A list with matrices for each of the impulse variables
    containing the impulse response coefficients.}
  \item{Lower}{If \code{boot = TRUE}, a list with matrices for each of
    the impulse variables containing the lower bands.}
  \item{Upper}{If \code{boot = TRUE}, a list with matrices for each of
    the impulse variables containing the upper bands.}
  \item{response}{Character vector holding the names of the response
    variables.}  
  \item{impulse}{Character vector holding the names of the impulse  variables.}
  \item{ortho}{Logical, if \code{TRUE}, orthogonalised impulse reponses
    have been computed.}
  \item{cumulative}{Logical, if \code{TRUE}, cumulated impulse reponses
    have been computed.}
  \item{runs}{An integer, specifying the number of bootstrap runs.}
  \item{ci}{Numeric, defining the confidence level.}
  \item{boot}{Logical, if \code{TRUE} bootstrapped error bands have been
    computed.}
  \item{model}{Character, containing \sQuote{\code{class(x)}}.}
}

\author{Bernhard Pfaff}

\references{
  Efron, B. and R. J. Tibshirani (1993), \emph{An Introduction to the
    Bootstrap}, Chapman \& Hall, New York. 
  
  Hamilton, J. (1994), \emph{Time Series Analysis}, Princeton
  University Press, Princeton.

  Lütkepohl, H. (2006), \emph{New Introduction to Multiple Time Series
    Analysis}, Springer, New York. 
}

\seealso{
    \code{\link{plot}} for the plot method. \code{\link{lineVar}}, \code{\link{VECM}} for the models. 

}

\examples{
data(barry)

## For VAR
mod_var <- lineVar(barry, lag = 2)
irf(mod_var, impulse = "dolcan", response = c("dolcan", "cpiUSA", "cpiCAN"), boot =
FALSE)

## For VECM
mod_VECM <- VECM(barry, lag = 2, estim="ML", r=2)
irf(mod_VECM, impulse = "dolcan", response = c("dolcan", "cpiUSA", "cpiCAN"), boot =
FALSE)
}


\keyword{regression}
\concept{VAR}
\concept{Vector autoregressive model}
\concept{irf}
\concept{impulse response function}
\concept{VECM}

