% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-nds-methods.R
\name{getNdsPrdst}
\alias{getNdsPrdst}
\title{Get pre-distances}
\usage{
getNdsPrdst(tree, ids, parallel = FALSE, progress = "none")
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{ids}{vector of node ids}

\item{parallel}{logical, make parallel?}

\item{progress}{name of the progress bar to use, see \code{\link{create_progress_bar}}}
}
\description{
Return root to tip distances (prdst) for \code{ids}
}
\details{
Sums the lengths of all branches from \code{ids} to root.
}
\examples{
library(treeman)
tree <- randTree(10)
getNdsPrdst(tree, ids=tree['tips'])  # return prdsts for all tips
}
\seealso{
\code{\link{getNdPrdst}},
\url{https://github.com/DomBennett/treeman/wiki/get-methods}
}
