% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimulateTrawl.R
\name{trawl_DExp}
\alias{trawl_DExp}
\title{Evaluates the double exponential trawl function}
\usage{
trawl_DExp(x, w, lambda1, lambda2)
}
\arguments{
\item{x}{the argument at which the double exponential trawl function will be
evaluated}

\item{w}{parameter in the double exponential trawl}

\item{lambda1}{the parameter \eqn{\lambda_1} in the double exponential trawl}

\item{lambda2}{the parameter \eqn{\lambda_2} in the double exponential trawl}
}
\value{
The double exponential trawl function evaluated at x
}
\description{
Evaluates the double exponential trawl function
}
\details{
The trawl function is parametrised by parameters \eqn{0\leq w\leq 1}
 and \eqn{\lambda_1, \lambda_2 > 0}  as follows: \deqn{g(x) = w e^{\lambda_1
 x}+(1-w) e^{\lambda_2 xz},  \mbox{ for }  x \le 0.}
}
\examples{
#Evaluate the trawl function at x=-2
trawl_DExp(-2,0.4,0.1,0.9)
#Plot the trawl function
plot(trawl_DExp(-(0:10),0.4,0.1,0.9))
}
