% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{logLik.tramME}
\alias{logLik.tramME}
\title{Get the log-likelihood of the model}
\usage{
\method{logLik}{tramME}(
  object,
  param = c(coef(object, with_baseline = TRUE, fixed = FALSE), varcov(object, as.theta
    = TRUE)),
  newdata = NULL,
  ...
)
}
\arguments{
\item{object}{A \code{tramME} object.}

\item{param}{An optional vector of parameter values in the structure
(beta, theta).}

\item{newdata}{An optional data.frame to calculate the out-of-sample
log-likelihood.}

\item{...}{Optional argument (for consistency with generic).}
}
\value{
A numeric value of the log-likelihood.
}
\description{
Get the log-likelihood of the model
}
\examples{
data("sleepstudy", package = "lme4")
fit <- LmME(Reaction ~ Days + (Days | Subject), data = sleepstudy)
logLik(fit)
}
