% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{sigma.LmME}
\alias{sigma.LmME}
\title{Extract the SD of the error term of an LmME model.}
\usage{
\method{sigma}{LmME}(object, ...)
}
\arguments{
\item{object}{An LmME object (fitted or unfitted).}

\item{...}{Optional argument (for consistency with generic)}
}
\value{
A numeric value of the transformed sigma parameter.
}
\description{
Extract the SD of the error term of an LmME model.
}
\examples{
data("sleepstudy", package = "lme4")
fit <- LmME(Reaction ~ Days + (Days | Subject), data = sleepstudy)
sigma(fit)
}
