% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotWordSub.R
\name{plotWordSub}
\alias{plotWordSub}
\title{Plotting Counts/Proportion of Words/Docs in LDA-generated Topic-Subcorpora over Time}
\usage{
plotWordSub(object, ldaresult, ldaID, limit = 10, alloc = c("multi",
  "unique", "best"), select = 1:nrow(ldaresult$document_sums), tnames,
  search, ignore.case = TRUE, type = c("docs", "words"), rel = TRUE,
  mark = TRUE, unit = "month", curves = c("exact", "smooth", "both"),
  smooth = 0.05, main, xlab, ylab, ylim, both.lwd, both.lty, col,
  legend = "topright", natozero = TRUE, file, ...)
}
\arguments{
\item{object}{\code{\link{textmeta}} object with strictly tokenized
\code{text} component (character vectors) - such as a result of
\code{\link{cleanTexts}}}

\item{ldaresult}{The result of a function call \code{\link{LDAgen}}}

\item{ldaID}{Character vector of IDs of the documents in
\code{ldaresult}}

\item{limit}{Integer/numeric: How often a word must be
 allocated to a topic to count these article as belonging
to this topic - if \code{0<limit<1} proportion is used (default: \code{10})?}

\item{alloc}{Character:  Should every article
be allocated to multiple topics (\code{"multi"}), or maximum one
topic (\code{"unique"}), or the most represantative  - exactly one -
topic (\code{"best"}) (default: \code{"multi"})? If \code{alloc = "best"} \code{limit} has no effect.}

\item{select}{Integer vector: Which topics of
\code{ldaresult} should be plotted (default: all topics)?}

\item{tnames}{Character vector of same length as \code{select}
- labels for the topics (default are the first returned words of
\code{\link{top.topic.words}} from the \code{lda} package for each topic)}

\item{search}{See \code{\link{filterWord}}}

\item{ignore.case}{See \code{\link{filterWord}}}

\item{type}{Character: Should counts/proportion of documents, where every
\code{"docs"} or words \code{"words"} be plotted (default: \code{"docs"})?}

\item{rel}{Logical. Should counts (\code{FALSE})
or proportion (\code{TRUE}) be plotted (default: \code{TRUE})?}

\item{mark}{Logical:  Should years be marked by
vertical lines (default: \code{TRUE})?}

\item{unit}{Character: To which unit should dates be floored
(default: \code{"month"})? Other possible units are "bimonth", "quarter", "season",
"halfyear", "year", for more units see \code{\link[lubridate]{round_date}}}

\item{curves}{Character: Should \code{"exact"},
\code{"smooth"} curve or \code{"both"} be plotted (default: \code{"exact"})?}

\item{smooth}{Numeric: Smoothing parameter
which is handed over to \code{\link{lowess}} as \code{f} (default: \code{0.05})}

\item{main}{Character: Graphical parameter}

\item{xlab}{Character: Graphical parameter}

\item{ylab}{Character: Graphical parameter}

\item{ylim}{Graphical parameter (default if \code{rel = TRUE}: \code{c(0, 1)})}

\item{both.lwd}{Graphical parameter for smoothed values
if \code{curves = "both"}}

\item{both.lty}{Graphical parameter for smoothed values
if \code{curves = "both"}}

\item{col}{Graphical parameter, could be a vector. If \code{curves = "both"}
the function will for every wordgroup plot at first the exact and then the
smoothed curve - this is important for your col order.}

\item{legend}{Character: Value(s) to specify the
legend coordinates (default: "topright"). If "none" no legend is plotted.}

\item{natozero}{Logical. Should NAs be coerced
to zeros (default: \code{TRUE})? Only has effect if \code{rel = TRUE}.}

\item{file}{Character: File path if a pdf should be created}

\item{...}{Additional graphical parameters}
}
\value{
A plot.
Invisible: A dataframe with columns \code{date} and \code{tnames} with the
counts/proportion of the selected topics.
}
\description{
Creates a plot of the counts/proportion of words/docs in corpora which are
generated by a \code{ldaresult}. Therefore an article is allocated to a topic
- and then to the topics corpus - if there are enough (see \code{limit} and
\code{alloc}) allocations of words in the article to the corresponding topic.
Additionally the corpora are reduced by \code{\link{filterWord}} and a
\code{search}-argument. The plot shows counts of subcorpora or if
\code{rel = TRUE} proportion of subcorpora to its corresponding whole corpus.
}
\examples{
\donttest{
data(politics)
poliClean <- cleanTexts(politics)
poliPraesidents <- filterWord(object=poliClean, search=c("bush", "obama"))
words10 <- makeWordlist(text=poliPraesidents$text)
words10 <- words10$words[words10$wordtable > 10]
poliLDA <- LDAprep(text=poliPraesidents$text, vocab=words10)
LDAresult <- LDAgen(documents=poliLDA, K=5, vocab=words10)
plotWordSub(object=poliClean, ldaresult=LDAresult, ldaID=names(poliLDA), search="obama")
}
}
