% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTopic.R
\name{plotTopic}
\alias{plotTopic}
\title{Plotting Counts of Topics over Time (Relative to Corpus)}
\usage{
plotTopic(object, ldaresult, ldaID,
  select = 1:nrow(ldaresult$document_sums), tnames, rel = FALSE,
  mark = TRUE, unit = "month", curves = c("exact", "smooth", "both"),
  smooth = 0.05, main, xlab, ylim, ylab, both.lwd, both.lty, col,
  legend = ifelse(pages, "onlyLast:topright", "topright"),
  pages = FALSE, natozero = TRUE, file, ...)
}
\arguments{
\item{object}{\code{\link{textmeta}} object with strictly tokenized
\code{text} component (character vectors) - such as a result of
\code{\link{cleanTexts}}}

\item{ldaresult}{The result of a function call \code{\link{LDAgen}}}

\item{ldaID}{Character vector of IDs of the documents in
\code{ldaresult}}

\item{select}{Integer: Which topics of
\code{ldaresult} should be plotted (default: all topics)?}

\item{tnames}{Character vector of same length as \code{select}
- labels for the topics (default are the first returned words of
\code{\link{top.topic.words}} from the \code{lda} package for each topic)}

\item{rel}{Logical: Should counts (\code{FALSE}) or
proportion (\code{TRUE}) be plotted (default: \code{FALSE})?}

\item{mark}{Logical: Should years be marked by
vertical lines (default: \code{TRUE})?}

\item{unit}{Character: To which unit should dates be floored
(default: \code{"month"})? Other possible units are \code{"bimonth"}, \code{"quarter"}, \code{"season"},
\code{"halfyear"}, \code{"year"}, for more units see \code{\link[lubridate]{round_date}}}

\item{curves}{Character: Should \code{"exact"},
\code{"smooth"} curve or \code{"both"} be plotted (default: \code{"exact"})?}

\item{smooth}{Numeric: Smoothing parameter
which is handed over to \code{\link{lowess}} as \code{f} (default: \code{0.05})}

\item{main}{Character: Graphical parameter}

\item{xlab}{Character: Graphical parameter}

\item{ylim}{Graphical parameter}

\item{ylab}{Character: Graphical parameter}

\item{both.lwd}{Graphical parameter for smoothed values
if \code{curves = "both"}}

\item{both.lty}{Graphical parameter for smoothed values
if \code{curves = "both"}}

\item{col}{Graphical parameter, could be a vector. If \code{curves = "both"}
the function will for every topicgroup plot at first the exact and then the
smoothed curve - this is important for your col order.}

\item{legend}{Character: Value(s) to specify the legend coordinates (default: \code{"topright"},
\code{"onlyLast:topright"} for \code{pages = TRUE} respectively).
If "none" no legend is plotted.}

\item{pages}{Logical: Should all curves be
plotted in a single plot (default: \code{FALSE})? In addtion you could set
\code{legend = "onlyLast:<argument>"} with \code{<argument>} as a
\code{character} \code{legend} argument
for only plotting a legend on the last plot of set.}

\item{natozero}{Logical: Should NAs be coerced
to zeros (default: \code{TRUE})? Only has effect if \code{rel = TRUE}.}

\item{file}{Character: File path if a pdf should be created}

\item{...}{Additional graphical parameters}
}
\value{
A plot.
Invisible: A dataframe with columns \code{date} and \code{tnames} with the
counts/proportion of the selected topics.
}
\description{
Creates a plot of the counts/proportion of specified topics of a result of
\code{\link{LDAgen}}. There is an option to plot all curves in one plot
or to create one plot for every curve (see \code{pages}).
In addition the plots can be written to a pdf by setting \code{file}.
}
\examples{
\donttest{
data(politics)
poliClean <- cleanTexts(politics)
words10 <- makeWordlist(text=poliClean$text)
words10 <- words10$words[words10$wordtable > 10]
poliLDA <- LDAprep(text=poliClean$text, vocab=words10)
LDAresult <- LDAgen(documents=poliLDA, K=10, vocab=words10)

# plot all topics
plotTopic(object=poliClean, ldaresult=LDAresult, ldaID=names(poliLDA))

# plot special topics
plotTopic(object=poliClean, ldaresult=LDAresult, ldaID=names(poliLDA), select=c(1,4))
}
}
