% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_repo.R
\name{setup_repo}
\alias{setup_repo}
\title{Initialize a new repository, and a single subfolder, TNTP style.}
\usage{
setup_repo(project_path, subfolder, proj_name, analyst_name)
}
\arguments{
\item{project_path}{the path to the main project directory. To use the current project, use `project_path = here::here()`.}

\item{subfolder}{a character vector containing the concise name of a project subfolder.
E.g., if the repository is the name of a city "Anywhere City", a project subfolder might be
"ela_access" or "aps_talent_landscape").}

\item{proj_name}{the longer, full name of the subfolder project.  This will
appear in the subfolder's README.md file.  E.g., "Access to Grade-Level ELA Content Pilot."}

\item{analyst_name}{the name(s) of the analysts currently working on the subfolder
project.  This will appear in the subfolder's README.md file.}
}
\value{
nothing
}
\description{
Create a new repository on Bitbucket, then set your working
directory to that folder and run this function.  It will set up the main
repo folder as well as a single subfolder in which you can work on your
immediate project.

You must specify the subfolder name as well as the long name associated with
that project and the analyst(s) working on it.  These latter two values are
used to create a README.Md file.
}
\examples{
# Setting up in a temporary directory
setup_repo(project_path = tempdir(),
           subfolder = "ela_access",
           proj_name = "Access to Grade-Level ELA Content",
           analyst_name = "Dustin Pashouwer and Sam Firke")
}
