% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tmlenet-package.R
\docType{data}
\name{NetInd_mat_Kmax6}
\alias{NetInd_mat_Kmax6}
\title{An example of a network ID matrix}
\usage{
data(NetInd_mat_Kmax6)
}
\description{
This matrix demonstrates an internal data structure of how \code{tmlenet} stores the input network.
The network in this matrix is derived from the column \code{"Net_str"} of the dataset \code{df_netKmax6}.
Both, this matrix and the vector of strings in column \code{"Net_str"}, represent the same network and both can be used
for specifying the input network to \code{tmlenet} function.
The network matrix may be specified by using the argument \code{NETIDmat} of the \code{tmlenet} function.
Inputing the network via this type of a matrix may lead to significant reduction in total run time,
since any network specified as a vector of strings, such as in column "Net_str",
will be first converted to this type of matrix representation.
}
\details{
See below and Example 3 in \code{tmlenet} help file for examples constructing this matrix from the initial network input in
column \code{"Net_str"} of \code{df_netKmax6}.

This matrix consists of \code{1000} rows and \code{6} columns. Each row \code{i} encodes a vector of network IDs of observation \code{i} in
\code{df_netKmax6}, i.e.,
\code{NetInd_mat_Kmax6[,i]} contains a vector of observation row numbers in \code{df_netKmax6} that are presumed "connected to" (or "friends of")
observation \code{i}. Each observation can have at most 6 friends and if an observation \code{i} has fewer than 6 friends the remainder row
of \code{NetInd_mat_Kmax6[,i]} is filled with \code{NA}s.
}
\examples{
data(df_netKmax6)
Net_str <- df_netKmax6[, "Net_str"]
IDs_str <- df_netKmax6[, "IDs"]
net_ind_obj <- simcausal::NetIndClass$new(nobs = nrow(df_netKmax6), Kmax = ncol(df_netKmax6))
net_ind_obj$makeNetInd.fromIDs(Net_str = Net_str, IDs_str = IDs_str, sep = ' ')
NetInd_mat <- net_ind_obj$NetInd
}
\keyword{datasets}

