% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tinytest.R
\name{test_package}
\alias{test_package}
\title{Test a package during R CMD check or after installation}
\usage{
test_package(pkgname, testdir = "tinytest", at_home = FALSE, ncpu = NULL, ...)
}
\arguments{
\item{pkgname}{\code{[character]} scalar. Name of the package, as in the \code{DESCRIPTION} file.}

\item{testdir}{\code{[character]} scalar. Path to installed directory, relative
to the working directory of \code{R CMD check}.}

\item{at_home}{\code{[logical]} scalar. Are we at home? (see Details)}

\item{ncpu}{A positive integer, or a \code{\link{makeCluster}} object.}

\item{...}{extra arguments passed to \code{\link{run_test_dir}} (e.g. \code{ncpu}).}
}
\value{
If \code{interactive()}, a \code{tinytests} object. If not
 \code{interactive()}, an error is thrown when at least one test fails.
}
\description{
Run all tests in an installed package. Throw an error and print all failed test
results when one or more tests fail if not in interactive mode (e.g. when
R CMD check tests a package). This function is intended to be
used by \code{R CMD check} or by a user that installed a package that
uses the \pkg{tinytest} test infrastructure.
}
\section{Details}{

We set \code{at_home=FALSE} by default so \code{R CMD check} will run the same
as at CRAN. See the package vignette (Section 4) for tips on how to set up
the package structure.
\code{vignette("using_tinytest",package="tinytest")}.
}

\examples{
\dontrun{
# Create a file with the following content, to use
# tinytest as your unit testing framework:
  if (requireNamespace("tinytest", quietly=TRUE))
    tinytest::test_package("your package name")
}
}
\seealso{
\code{\link{setup_tinytest}}

Other test-files: 
\code{\link{build_install_test}()},
\code{\link{exit_file}()},
\code{\link{run_test_dir}()},
\code{\link{run_test_file}()},
\code{\link{summary.tinytests}()}
}
\concept{test-files}
