% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics-tk_summary_diagnostics.R
\name{tk_summary_diagnostics}
\alias{tk_summary_diagnostics}
\title{Group-wise Time Series Summary}
\usage{
tk_summary_diagnostics(.data, .date_var)
}
\arguments{
\item{.data}{A \code{tibble} or \code{data.frame} with a time-based column}

\item{.date_var}{A column containing either date or date-time values}
}
\value{
A \code{tibble} or \code{data.frame} with timeseries summary features
}
\description{
\code{tk_summary_diagnostics()} returns the time series summary from
one or more timeseries groups in a tibble.
}
\details{
Applies \code{\link[=tk_get_timeseries_summary]{tk_get_timeseries_summary()}} group-wise returning the summary of one or more
time series groups.
\itemize{
\item Respects \code{dplyr} groups
\item Returns the time series summary from a time-based feature.
}
}
\examples{
library(dplyr)
library(timetk)

# ---- GROUPED EXAMPLES ----

# Hourly Data
m4_hourly \%>\%
    group_by(id) \%>\%
    tk_summary_diagnostics(date)


}
