% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArraySchema.R
\name{tiledb_array_schema}
\alias{tiledb_array_schema}
\title{Constructs a \code{tiledb_array_schema} object}
\usage{
tiledb_array_schema(
  domain,
  attrs,
  cell_order = "COL_MAJOR",
  tile_order = "COL_MAJOR",
  sparse = FALSE,
  coords_filter_list = NULL,
  offsets_filter_list = NULL,
  ctx = tiledb_get_context()
)
}
\arguments{
\item{domain}{tiledb_domain object}

\item{attrs}{a list of one or more tiledb_attr objects}

\item{cell_order}{(default "COL_MAJOR")}

\item{tile_order}{(default "COL_MAJOR")}

\item{sparse}{(default FALSE)}

\item{coords_filter_list}{(optional)}

\item{offsets_filter_list}{(optional)}

\item{ctx}{tiledb_ctx object (optional)}
}
\description{
Constructs a \code{tiledb_array_schema} object
}
\examples{
schema <- tiledb_array_schema(
              dom = tiledb_domain(
                        dims = c(tiledb_dim("rows", c(1L, 4L), 4L, "INT32"),
                                 tiledb_dim("cols", c(1L, 4L), 4L, "INT32"))),
              attrs = c(tiledb_attr("a", type = "INT32")),
              cell_order = "COL_MAJOR",
              tile_order = "COL_MAJOR",
              sparse = FALSE)
schema

}
