% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpcstats.R
\name{binning}
\alias{binning}
\alias{binning.tidyvpcobj}
\title{Binning methods for Visual Predictive Check (VPC)}
\usage{
binning(o, ...)

\method{binning}{tidyvpcobj}(
  o,
  bin,
  data = o$data,
  xbin = "xmedian",
  centers,
  breaks,
  nbins,
  altx,
  stratum = NULL,
  by.strata = TRUE,
  ...
)
}
\arguments{
\item{o}{A \code{tidyvpcobj}.}

\item{...}{Other arguments to include.}

\item{bin}{Character string indicating binning method or unquoted variable name if binning on x-variable.}

\item{data}{Observed data supplied in \code{observed()} function.}

\item{xbin}{Character string indicating midpoint type for binning.}

\item{centers}{Numeric vector of centers for binning. Use \code{bin = "centers"}, if supplying centers.}

\item{breaks}{Numeric vector of breaks for binning. Use \code{bin = "breaks"}, if supplying breaks.}

\item{nbins}{Numeric number indicating the number of bins to use.}

\item{altx}{Unquoted variable name in observed data for alternative x-variable binning.}

\item{stratum}{List indicating the name of stratification variable and level, if using different binning methods by strata.}

\item{by.strata}{Logical indicating whether binning should be performed by strata.}
}
\value{
Updates \code{tidyvpcobj} with \code{data.frame} containing bin information including left/right boundaries and midpoint, as specified in \code{xbin} argument.
}
\description{
This function executes binning methods available in classInt i.e. "jenks", "kmeans", "sd", "pretty", "pam", "kmeans", "hclust", "bclust", "fisher", and "dpih".
You may also bin directly on x-variable or alternatively specify "centers" or "breaks". For explanation of binning methods see \code{\link[classInt]{classIntervals}}.
}
\examples{
require(magrittr)

 # Binning on x-variable NTIME
vpc <- observed(obs_data, x=TIME, y=DV) \%>\%
    simulated(sim_data, y=DV) \%>\%
    binning(bin = NTIME) \%>\%
    vpcstats()
    
 # Binning using ntile and xmean for midpoint
vpc <- observed(obs_data, x=TIME, y=DV) \%>\%
    simulated(sim_data, y=DV) \%>\%
    binning(bin = "ntile", nbins = 8, xbin = "xmean") \%>\%
    vpcstats()
    
 # Binning using centers
vpc <- observed(obs_data, x=TIME, y=DV) \%>\%
    simulated(sim_data, y=DV) \%>\%
    binning(bin = "centers", centers = c(1,3,5,7)) \%>\%
    vpcstats()
        
 # Different Binning for each level of Strata
vpc <- observed(obs_data, x=TIME, y=DV) \%>\%
    simulated(sim_data, y=DV) \%>\%
    stratify(~ GENDER) \%>\%
    binning(stratum = list(GENDER = "M"), bin = "jenks", nbins = 5, by.strata = TRUE) \%>\%
    binning(stratum = list(GENDER = "F"), bin = "pam", nbins = 4, by.strata = TRUE) \%>\%
    vpcstats()
    
 # Binning Categorical DV using rounded time variable
  
  vpc <- observed(obs_cat_data, x = agemonths, y = zlencat ) \%>\%
      simulated(sim_cat_data, y = DV) \%>\%
      binning(bin = round(agemonths, 0)) \%>\%
      vpcstats(vpc.type = "categorical")

}
\seealso{
\code{\link{observed}} \code{\link{simulated}} \code{\link{censoring}} \code{\link{predcorrect}} \code{\link{stratify}} \code{\link{binless}} \code{\link{vpcstats}}
}
