% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.tidyvpcobj}
\alias{plot.tidyvpcobj}
\title{Plot a \code{tidyvpcobj}}
\usage{
\method{plot}{tidyvpcobj}(
  x,
  ...,
  facet = FALSE,
  show.points = TRUE,
  show.boundaries = TRUE,
  show.stats = !is.null(x$stats),
  show.binning = isFALSE(show.stats),
  xlab = NULL,
  ylab = NULL,
  color = c("red", "blue", "red"),
  linetype = c("dotted", "solid", "dashed"),
  legend.position = "top",
  facet.scales = "free",
  custom.theme = "ggplot2::theme_bw"
)
}
\arguments{
\item{x}{A \code{tidyvpcobj}.}

\item{...}{Further arguments can be specified but are ignored.}

\item{facet}{Should the resulting plot automatically facet by category? Only applicable for categorical VPC.}

\item{show.points}{Should the observed data points be plotted?}

\item{show.boundaries}{Should the bin boundary be displayed?}

\item{show.stats}{Should the VPC stats be displayed?}

\item{show.binning}{Should the binning be displayed by coloring the observed data points by bin?}

\item{xlab}{A character label for the x-axis.}

\item{ylab}{A character label for the y-axis.}

\item{color}{A character vector of colors for the percentiles, from low to high.}

\item{linetype}{A character vector of line type for the percentiles, from low to high.}

\item{legend.position}{A character string specifying the position of the legend.}

\item{facet.scales}{A character string specifying the \code{scales} argument to use for faceting.}

\item{custom.theme}{A character string specifying theme from ggplot2 package.}
}
\value{
A \code{ggplot} object.
}
\description{
Use ggplot2 graphics to plot and customize the appearance of VPC.
}
\seealso{
\code{ggplot}
}
